$._ext_InfinityColor={
	createHarmonies : function(path)
	{
	    try
        {
        	$._ext_InfinityColor.runScript(path + '/jsx/harmonize.jsxbin');
		}
		catch (ex)
		{
			alert("Something went horribly wrong.");
		}
	},

	runRandomScripts : function(path, strength, curves, colorbalance, selectivecolor, gradientmap, colorlookup)
	{
		
	    try
        {
        	$._ext_InfinityColor.runScript(path + '/jsx/remove_old.jsxbin');
        	
        	if (curves)
        	{
        		$._ext_InfinityColor.runScript(path + '/jsx/generate_curve_' +  strength + '.jsxbin');
        	}
        	
        	if (colorbalance)
        	{
        		$._ext_InfinityColor.runScript(path + '/jsx/generate_colorbalance_' +  strength + '.jsxbin');
        	}

        	if (selectivecolor)
        	{
        		$._ext_InfinityColor.runScript(path + '/jsx/generate_selectivecolor_' +  strength + '.jsxbin');
        	}

        	if (gradientmap)
        	{
        		$._ext_InfinityColor.runScript(path + '/jsx/generate_gradientmap_' +  strength + '.jsxbin');
        	}

        	if (colorlookup)
        	{
        		$._ext_InfinityColor.runScript(path + '/jsx/generate_colorlookup.jsxbin');
        	}
		}
		catch (ex)
		{
			alert("Something went horribly wrong.");
		}
	},
	
	runRandomScriptsSuspend : function(path, strength, curves, colorbalance, selectivecolor, gradientmap, colorlookup)
	{
		app.activeDocument.suspendHistory("Infinite Color", "$._ext_InfinityColor.runRandomScripts('" + path + "', " + strength + ", " + curves + ", " + colorbalance + ", " + selectivecolor + ", " + gradientmap + ", " + colorlookup + ")");
	},

    runSpecificScript : function(path, name, strength)
    {
        switch(name)
        {
            case "shuffle_curves":
                $._ext_InfinityColor.runScript(path + '/jsx/generate_curve_' +  strength + '.jsxbin');
                break;
            case "shuffle_colorbalance":
                $._ext_InfinityColor.runScript(path + '/jsx/generate_colorbalance_' +  strength + '.jsxbin');
                break;
            case "shuffle_selectivecolor":
                $._ext_InfinityColor.runScript(path + '/jsx/generate_selectivecolor_' +  strength + '.jsxbin');
                break;
            case "shuffle_gradientmap":
                $._ext_InfinityColor.runScript(path + '/jsx/generate_gradientmap_' +  strength + '.jsxbin');
                break;
            case "shuffle_colorlookup":
                $._ext_InfinityColor.runScript(path + '/jsx/generate_colorlookup.jsxbin');
                break;
            default:
                alert('Invalid shuffle: ' + name);
                break;
        }
    },

    runSpecificScriptSuspend : function(path, name, strength)
    {
        app.activeDocument.suspendHistory("Infinite Color Shuffle", "$._ext_InfinityColor.runSpecificScript('" + path + "', '" + name + "', " + strength + ");");
    },

    runAction : function(name)
    {
        try
        {
            var idPly = charIDToTypeID( "Ply " );
            var desc3 = new ActionDescriptor();
            var idnull = charIDToTypeID( "null" );
            var ref1 = new ActionReference();
            var idActn = charIDToTypeID( "Actn" );
            ref1.putName( idActn, name );
            var idASet = charIDToTypeID( "ASet" );
            ref1.putName( idASet, "Infinity Color" );
            desc3.putReference( idnull, ref1 );
            executeAction( idPly, desc3, DialogModes.NO );
            if (app.documents.length > 0)
            {
                var fix = app.activeDocument;
                app.activeDocument = fix;
            }
        }
        catch (ex)
        {
            if (ex.message.indexOf(" is not currently available."))
            {
                var doInstall = confirm("Infinity Color Error\nThe infinity color actions seems to be missing. Would you like to install them now?");
                if (doInstall == true)
                {
                    var idAdobeScriptAutomationScripts = stringIDToTypeID( "AdobeScriptAutomation Scripts" );
                    var desc2 = new ActionDescriptor();
                    var idjsNm = charIDToTypeID( "jsNm" );
                    desc2.putString( idjsNm, """Install Infinity Color...""" );
                    var idjsMs = charIDToTypeID( "jsMs" );
                    desc2.putString( idjsMs, """undefined""" );
                    executeAction( idAdobeScriptAutomationScripts, desc2, DialogModes.NO );   
                }
            }
        }
    },
    
    runActionNoError : function(name)
    {
        try
        {
            var idPly = charIDToTypeID( "Ply " );
            var desc3 = new ActionDescriptor();
            var idnull = charIDToTypeID( "null" );
            var ref1 = new ActionReference();
            var idActn = charIDToTypeID( "Actn" );
            ref1.putName( idActn, name );
            var idASet = charIDToTypeID( "ASet" );
            ref1.putName( idASet, "Infinity Color" );
            desc3.putReference( idnull, ref1 );
            executeAction( idPly, desc3, DialogModes.NO );
            if (app.documents.length > 0)
            {
                var fix = app.activeDocument;
                app.activeDocument = fix;
            }
        }
        catch (ex)
        {
        }
    },
    
    runScript : function(scriptfile)
    {
		$._ext.evalFile(scriptfile);
    },
    
    runMenuScript : function(name)
    {
        var idAdobeScriptAutomationScripts = stringIDToTypeID( "AdobeScriptAutomation Scripts" );
        var desc4 = new ActionDescriptor();
        var idjsNm = charIDToTypeID( "jsNm" );
        desc4.putString( idjsNm, name );
        var idjsMs = charIDToTypeID( "jsMs" );
        desc4.putString( idjsMs, "undefined" );
        var outputDesc = new ActionDescriptor();
        outputDesc = executeAction( idAdobeScriptAutomationScripts, desc4, DialogModes.NO );
        
        if (outputDesc.count == 0)
        {
            alert("Infinity Color Error\nScript not found!\n\nPlease make sure the scripts are installed properly.");
        }
        
        if (app.documents.length > 0)
        {
            var fix = app.activeDocument;
            app.activeDocument = fix;
        }
    },
};


